#include "SimBall.h"

namespace SimulationEngine
{

SimBall::SimBall()
{
	
}

SimBall::SimBall(DataBall data): ISimEntity(data.GetDataEntityId())
{
	DataSphere *newsphere = new DataSphere(0, data.GetRadius(), data.GetPosition(),data.GetRotation(), data.GetMaterialId(), data.GetMass(), data.GetLinearVelocity(),data.GetAngularVelocity());
	IPhysicsController *physics = PhysicsControllerFactory::GetInstance()->GetPhysicsController();
	this->physicalball = (IPhysicalSphere *)physics->CreatePhysicalBody(data.GetDataEntityId(), newsphere);
}

SimBall::~SimBall()
{
	delete physicalball;
}

string SimBall::GetSimString()
{
	string ret = "<Ball_Entity><Entity_Id>";
	stringstream id;
	id<< this->GetEntityId();
	ret+= id.str();
	ret+= "</Entity_Id>";
	Vector3f pos = physicalball->GetPosition();
	Vector3f rot = physicalball->GetRotation();
	ret +=  pos.ToString("Position_X","Position_Y","Position_Z")+
		  rot.ToString("Rotation_X","Rotation_Y","Rotation_Z")+"</Ball_Entity>";
	return ret;
}

void SimBall::SetEntityPosition(float posx, float posy, float posz)
{
	this->physicalball->SetPhysicalPosition(posx,posy,posz);
}

string SimBall::PersistEntity()
{
	this->physicalball->UpdateData();
	string ret = "<Entity Type=\"Ball\"><Entity_id>";
	stringstream id;
	id<< this->GetEntityId();
	ret+= id.str();
	ret+= "</Entity_id><Material>";
	stringstream mat;
	mat<< physicalball->GetMaterialId();
	ret+= mat.str() + "</Material><Mass>";
	stringstream mass;
	mass<< physicalball->GetMass();
	ret+= mass.str() + "</Mass>";
	Vector3f pos = physicalball->GetPosition();
	Vector3f rot = physicalball->GetRotation();
	ret +=  pos.ToString("Position_X","Position_Y","Position_Z")+
		  rot.ToString("Rotation_X","Rotation_Y","Rotation_Z")+"<Radius>";
	stringstream radius;
	radius<< physicalball->GetRadius();
	ret+= radius.str() + "</Radius>";
	Vector3f angularvel = this->physicalball->GetAngularVelocity();
	Vector3f linearvel = this->physicalball->GetLinearVelocity();
	ret+= angularvel.ToString("Angular_Velocity_X","Angular_Velocity_Y","Angular_Velocity_Z")+linearvel.ToString("Linear_Velocity_X","Linear_Velocity_Y","Linear_Velocity_Z");
	ret+="</Entity>";
	
	return ret;
}


}
